/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public class TagDifferencePresentCondition<T>
implements ConditionJsonProvider {
    public static final class_2960 NAME = TConstruct.getResource("tag_difference_present");
    private final class_6862<T> base;
    private final List<class_6862<T>> subtracted;

    public TagDifferencePresentCondition(class_6862<T> base, List<class_6862<T>> subtracted) {
        if (subtracted.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a condition with no subtracted");
        }
        this.base = base;
        this.subtracted = subtracted;
    }

    @SafeVarargs
    public static <T> TagDifferencePresentCondition<T> ofKeys(class_6862<T> base, class_6862<T> ... subtracted) {
        return new TagDifferencePresentCondition<T>(base, Arrays.asList(subtracted));
    }

    public static <T> TagDifferencePresentCondition<T> ofNames(class_5321<? extends class_2378<T>> registry, class_2960 base, class_2960 ... subtracted) {
        class_6862 baseKey = class_6862.method_40092(registry, (class_2960)base);
        return new TagDifferencePresentCondition<T>(baseKey, Arrays.stream(subtracted).map(name -> class_6862.method_40092((class_5321)registry, (class_2960)name)).toList());
    }

    public class_2960 getConditionId() {
        return NAME;
    }

    public boolean test() {
        Collection<class_6880<T>> base = this.getTag(this.base);
        if (base == null || base.isEmpty()) {
            return false;
        }
        if (this.subtracted.isEmpty()) {
            return true;
        }
        block0: for (class_6880<T> entry : base) {
            for (class_6862<T> tag : this.subtracted) {
                if (!this.getTag(tag).contains(entry)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private Collection<class_6880<T>> getTag(class_6862<T> tag) {
        @Nullable Map allTags = (Map)ResourceConditionsImpl.LOADED_TAGS.get();
        if (allTags == null) {
            ResourceConditionsImpl.LOGGER.warn("Can't retrieve deserialized tags. Failing tconstruct:tag_difference_present resource condition check.");
            return Set.of();
        }
        Map tags = (Map)allTags.get(this.base.comp_326());
        if (tags == null) {
            return Set.of();
        }
        return tags.getOrDefault(tag.comp_327(), Set.of());
    }

    public void writeParameters(JsonObject json) {
        json.addProperty("registry", this.base.comp_326().method_29177().toString());
        json.addProperty("base", this.base.comp_327().toString());
        JsonArray names = new JsonArray();
        for (class_6862<T> name : this.subtracted) {
            names.add(name.comp_327().toString());
        }
        json.add("subtracted", (JsonElement)names);
    }

    public static <T> TagDifferencePresentCondition<T> readGeneric(JsonObject json) {
        class_5321 registry = class_5321.method_29180((class_2960)JsonHelper.getResourceLocation((JsonObject)json, (String)"registry"));
        return new TagDifferencePresentCondition<T>(class_6862.method_40092((class_5321)registry, (class_2960)JsonHelper.getResourceLocation((JsonObject)json, (String)"base")), JsonHelper.parseList((JsonObject)json, (String)"subtracted", (e, s) -> class_6862.method_40092((class_5321)registry, (class_2960)JsonHelper.convertToResourceLocation((JsonElement)e, (String)s))));
    }
}

